// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// TunerCtrlDlg.h : header file
//

/*---------------------------------------------------------------------------------------

	Filename:	TunerCtrlDlg.n

	Description:	

	History:		
		04/27/07	Change format of incoming IR data from  WORD to BYTE. [ARS]

	Copyright (c) 1998-2004, B2C2, Inc.
	Copyright (c) 2004-2007, Broadband Technologies, Inc.

	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INC. The copyright notice 
	above does not evidence any actual or intended publication of such source code.

	This file is released pursuant to and subject to the restrictions of the 
	non-disclosure agreement and license contract entered into by the parties.

---------------------------------------------------------------------------------------*/

#if !defined(AFX_TUNERCTRLDLG_H__9736E1F5_73B6_4FBF_9945_DF7266DA9DDD__INCLUDED_)
#define AFX_TUNERCTRLDLG_H__9736E1F5_73B6_4FBF_9945_DF7266DA9DDD__INCLUDED_

//#include "DvrMain.h"
#include "resource.h"
#include "afxwin.h"
#include "B2FilterGraphHandler.h"
#include "afxcmn.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_IR_DATA	4	// Maximun number of IR entries

typedef interface IGraphBuilder			IGraphBuilder;
typedef interface IBaseFilter			IBaseFilter;
typedef interface IB2C2MPEG2DataCtrl6	IB2C2MPEG2DataCtrl6;
typedef interface IB2C2MPEG2TunerCtrl4	IB2C2MPEG2TunerCtrl4;
typedef interface IB2C2MPEG2AVCtrl3		IB2C2MPEG2AVCtrl3;

class CB2C2DeviceNotification;

class B2C2MPEG2Adapter;
class CAVStreamingDlg;
class CTSRecordingDlg;

typedef struct
{
	CAVStreamingDlg* m_pAVStreamingDlg;
	char szNetworkAdapter[20];
	char szMulticastAddress[20];
	WORD wMulticastPort;
	long alPIDList[5];
	long lPIDCount;
}
tMulticastInfo;

typedef struct
{
	long lFileSizeLimit;
	long lTimeLimit;
}
tRecordingInfo;

/*
typedef struct 
{
	long lFrequencyKhz;
	long lLnbFrequencyKhz;
	long lSymbolRateMs;
	int iGuardIntervalIndex;
	int iSatDiseqcIndex; 
	int iSatFECIndex; 
	int iSatLnbSelectionIndex;
	int iSatPolarityIndex;
	long iVideoPID;
	long iAudioPID;
}tTuningParameters;
*/

/////////////////////////////////////////////////////////////////////////////
// CTunerCtrlDlg dialog

class CTunerCtrlDlg : public CDialog
{
// Construction
public:
	CTunerCtrlDlg(CWnd* pParent = NULL);	// standard constructor
	~CTunerCtrlDlg();

//	void PassTuningParameters (tTuningParameters* pTuningParameters);

// Dialog Data
	//{{AFX_DATA(CTunerCtrlDlg)
	enum { IDD = IDD_TUNERCTRL_DIALOG };
	float	m_fFrequency;
	long	m_lPID;
	long	m_lSatLnbFrequency;
	long	m_lSymbolRate;
	long	m_lSatTunerFrequency;
	int		m_iGuardIntervalIndex;
	int		m_iVideoPID;
	int		m_iAudioPID;
	long	m_lRecordingFileSizeLimit;
	long	m_lRecordingTimeLimit;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTunerCtrlDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void InitializeNotification();
	void ReleaseNotification();

	CB2C2DeviceNotification *m_pDevNotify;

	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CTunerCtrlDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonAddPid();
	afx_msg void OnButtonDelPid();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnButtonApplyTunerSettings();
	afx_msg void OnReset();
	afx_msg void OnChangeEditFrequency();
	afx_msg void OnButtonShowPids();
	afx_msg void OnButtonSetUnicastMac();
	afx_msg void OnBnClickedPlayAudioVideo();
	afx_msg void OnBnClickedButtonStream();
	afx_msg void OnDeviceChange(WPARAM wChangeEvent, LPARAM lData);
	afx_msg void OnCbnSelchangeComboBandwidth();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected: // Methods
	HRESULT ShowUserInterface();
	void HideUserInterface();

	void ReleaseB2C2Filter();
	void CallSysFreeString ();

	void UpdatePerformanceStatistics(void);
	void EnableTuneButton(BOOL bEnable);
	void ZeroPerformanceStatistics() ;
	void UpdateTunerSettings(void);
	void UpdateMacAddressField (void);
	HRESULT InitializeB2C2Filter();
	void PopulateLists ();

	// Close Audio/Video Streaming Dialogs
	void CloseAVStreamingDlgs( void );

	HRESULT SelectDevice();

private: // Member variables
	BOOL	m_bProcessTunerFields;
	BOOL	m_bProcessPidFields;
	tTunerCapabilities m_TunerCapabilities;
	int		m_nSatPolarityIndex;
	int		m_nSatLnbSelectionIndex;
	int		m_nSatFECIndex;
	int		m_nSatDiseqcIndex;
	long	m_nModulationIndex;
	long	m_lCorrectedBlocksAccumulated;
	long	m_lUncorrectedBlocksAccumulated;
	long	m_lTotalBlocksAccumulated;

	long	m_lSignalLevel;
	float	m_fSNR;
	long	m_lCorrectedBlocks;
	float	m_fBER;
	long	m_lSignalStrength;
	long	m_lSignalQuality;
	long	m_lTsQuality;
	long	m_lIpQuality;
	BOOL	m_bListboxesInitialized;

	BYTE	m_ucIRData[MAX_IR_DATA * 2];
	DWORD	m_dwIRDataCount;

	BOOL	m_bTunerLocked;

	IB2C2MPEG2TunerCtrl4	*m_pB2C2FilterTunerCtrl;
	IB2C2MPEG2DataCtrl6		*m_pB2C2FilterDataCtrl;
	IB2C2MPEG2AVCtrl3		*m_pB2C2FilterAVCtrl;

	CB2FilterGraphHandler* m_pB2FilterGraph;

	int		m_nTimerCheckParameters;
	int		m_nTimerCheckIRData;
	int		m_nTimerClearIRData;

	int		m_nIRDataDuplicateCount;
	BYTE	m_ucPreviousIRData[2];

public: // Member variables


private: // Temoprary member variables
	CString	m_csTemp;
public:

	BOOL m_bAutoDeleteTimeshift;
	BOOL m_bAutoStartTimeshift;
private:
	DWORD m_dwMulticastAddress;
	DWORD m_dwMulticastPort;
	DWORD m_dwMulticastPID1;
	DWORD m_dwMulticastPID2;
	DWORD m_dwMulticastPID3;
	DWORD m_dwMulticastPID4;
	DWORD m_dwMulticastPID5;

	tMulticastInfo MulticastInfo[20];
	tRecordingInfo RecordingInfo;

	int m_iBandwidthIndex;

	CTSRecordingDlg* m_pTSRecordingDlg;

public:
	CIPAddressCtrl m_MulticastAddressCtrl;
	CIPAddressCtrl m_NetworkAdapterCtrl;
	afx_msg void OnBnClickedButtonShowAllPids();
	afx_msg void OnBnClickedButtonShowTsPids();
	afx_msg void OnBnClickedButtonGoEast();
	afx_msg void OnBnClickedButtonStop();
	afx_msg void OnBnClickedButtonGoWest();
	afx_msg void OnBnClickedStaticRecordTs();
	afx_msg void OnBnClickedButtonRecord();

	unsigned char m_szRecordFileName[80];
};


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TUNERCTRL_DLG_H__9736E1F5_73B6_4FBF_9945_DF7266DA9DDD__INCLUDED_)
